﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace YumeNikkiRandomizer
{
    class Database
    {
        string filepath = "";
        string filename = "";
        
        Heroes heroes; // 0b
        Skills skills; // 0c
        Items items; // 0d
        Monsters monsters; // 0e
        Troops troops; // 0f
        Terrains terrains; // 10
        Attributes attributes; // 11
        Conditions conditions; // 12
        Animations animations; // 13
        ChipSets chipSets; // 14
        Vocab vocab; // 15
        System system; // 16
        Switches switches; // 17
        Variables variables; // 18
        CommonEvents commonEvents; // 19
        int version = -1; // 1a (2003)
        // 1b and 1c are unused Common Events 2/3 (2003)
        BattleSettings battleSettings; // 1d (2003)
        Classes classes; // 1e (2003)
        // 1f is unused Classes 2 (2003)
        BattlerAnimations battlerAnimations; // 20 (2003)
        
        static string myClass = "Database";
        Chunks chunks;
        
        public Database(string filepath)
        {
            loadFile(filepath);
        }
        public Database()
        {
        }
        
        // Loads the .ldb file. Returns success.
        public bool loadFile(string filepath)
        {
            if (!File.Exists(filepath))
            {
                Console.WriteLine("Database file " + filepath + " not found.");
                return false;
            }
            
            this.filepath = filepath;
            filename = Path.GetFileName(filepath);
            M.currentFile = filename;
            
            M.debugMessage("Loading database...");
            
            FileStream f = File.OpenRead(filepath);
            
            try
            {
                chunks = new Chunks(f, myClass);
                
                M.stringCheck(f, "LcfDataBase");
                
                if (chunks.next(0x0b))
                {
                    M.readMultibyte(f);
                    heroes = new Heroes(f);
                }
                if (chunks.next(0x0c))
                {
                    M.readMultibyte(f);
                    skills = new Skills(f);
                }
                if (chunks.next(0x0d))
                {
                    M.readMultibyte(f);
                    items = new Items(f);
                }
                if (chunks.next(0x0e))
                {
                    M.readMultibyte(f);
                    monsters = new Monsters(f);
                }
                if (chunks.next(0x0f))
                {
                    M.readMultibyte(f);
                    troops = new Troops(f);
                }
                if (chunks.next(0x10))
                {
                    M.readMultibyte(f);
                    terrains = new Terrains(f);
                }
                if (chunks.next(0x11))
                {
                    M.readMultibyte(f);
                    attributes = new Attributes(f);
                }
                if (chunks.next(0x12))
                {
                    M.readMultibyte(f);
                    conditions = new Conditions(f);
                }
                if (chunks.next(0x13))
                {
                    M.readMultibyte(f);
                    animations = new Animations(f);
                }
                if (chunks.next(0x14))
                {
                    M.readMultibyte(f);
                    chipSets = new ChipSets(f);
                }
                if (chunks.next(0x15))
                {
                    M.readMultibyte(f);
                    vocab = new Vocab(f);
                }
                if (chunks.next(0x16))
                {
                    M.readMultibyte(f);
                    system = new System(f);
                }
                if (chunks.next(0x17))
                {
                    M.readMultibyte(f);
                    switches = new Switches(f);
                }
                if (chunks.next(0x18))
                {
                    M.readMultibyte(f);
                    variables = new Variables(f);
                }
                if (chunks.next(0x19))
                {
                    M.readMultibyte(f);
                    commonEvents = new CommonEvents(f);
                }
                
                if (chunks.next(0x1a))
                    version = M.readMultibyte(f);
                
                if (chunks.next(0x1b))
                    M.byteCheck(f, 0x00);
                if (chunks.next(0x1c))
                    M.byteCheck(f, 0x00);
                
                if (chunks.next(0x1d))
                {
                    M.readMultibyte(f);
                    battleSettings = new BattleSettings(f);
                }
                if (chunks.next(0x1e))
                {
                    M.readMultibyte(f);
                    classes = new Classes(f);
                }
                
                if (chunks.next(0x1f))
                    M.byteCheck(f, 0x00);
                
                if (chunks.next(0x20))
                {
                    M.readMultibyte(f);
                    battlerAnimations = new BattlerAnimations(f);
                }
                
                f.Close();
            }
            catch (Exception e)
            {
                M.debugMessage(e.StackTrace);
                M.debugMessage(e.Message);
                Console.WriteLine("Aborting due to error.");
                
                f.Close();
                return false;
            }
            
            return true;
        }
        
        // Applies the validated random layout.
        public void applyLayout()
        {
            terrains.applyLayout();
            commonEvents.applyLayout();
        }
        
        // Checks common events for teleports.
        public void getWarps()
        {
            commonEvents.getWarps();
        }
        
        // Saves database file from stored data.
        public bool writeFile(string newFile = "")
        {
            if (newFile == "")
                newFile = filepath;
            
            if (M.fileInUse(newFile))
            {
                Console.WriteLine(filename + " is in use; cannot save.");
                return false;
            }
            
            BinaryWriter dbWriter = new BinaryWriter(new FileStream(newFile, FileMode.Create));
            M.targetWriter = dbWriter;
            
            try
            {
                M.writeString("LcfDataBase", M.S_CONSTANT);
                
                if (chunks.wasNext(0x0b))
                {
                    M.writeMultibyte(heroes.getLength());
                    heroes.write();
                }
                if (chunks.wasNext(0x0c))
                {
                    M.writeMultibyte(skills.getLength());
                    skills.write();
                }
                if (chunks.wasNext(0x0d))
                {
                    M.writeMultibyte(items.getLength());
                    items.write();
                }
                if (chunks.wasNext(0x0e))
                {
                    M.writeMultibyte(monsters.getLength());
                    monsters.write();
                }
                if (chunks.wasNext(0x0f))
                {
                    M.writeMultibyte(troops.getLength());
                    troops.write();
                }
                if (chunks.wasNext(0x10))
                {
                    M.writeMultibyte(terrains.getLength());
                    terrains.write();
                }
                if (chunks.wasNext(0x11))
                {
                    M.writeMultibyte(attributes.getLength());
                    attributes.write();
                }
                if (chunks.wasNext(0x12))
                {
                    M.writeMultibyte(conditions.getLength());
                    conditions.write();
                }
                if (chunks.wasNext(0x13))
                {
                    M.writeMultibyte(animations.getLength());
                    animations.write();
                }
                if (chunks.wasNext(0x14))
                {
                    M.writeMultibyte(chipSets.getLength());
                    chipSets.write();
                }
                if (chunks.wasNext(0x15))
                {
                    M.writeMultibyte(vocab.getLength());
                    vocab.write();
                }
                if (chunks.wasNext(0x16))
                {
                    M.writeMultibyte(system.getLength());
                    system.write();
                }
                if (chunks.wasNext(0x17))
                {
                    M.writeMultibyte(switches.getLength());
                    switches.write();
                }
                if (chunks.wasNext(0x18))
                {
                    M.writeMultibyte(variables.getLength());
                    variables.write();
                }
                if (chunks.wasNext(0x19))
                {
                    M.writeMultibyte(commonEvents.getLength());
                    commonEvents.write();
                }
                if (chunks.wasNext(0x1a))
                    M.writeMultibyte(version);
                
                if (chunks.wasNext(0x1b))
                    M.writeByte(0x00);
                if (chunks.wasNext(0x1c))
                    M.writeByte(0x00);
                
                if (chunks.wasNext(0x1d))
                {
                    M.writeMultibyte(battleSettings.getLength());
                    battleSettings.write();
                }
                if (chunks.wasNext(0x1e))
                {
                    M.writeMultibyte(classes.getLength());
                    classes.write();
                }
                
                if (chunks.wasNext(0x1f))
                    M.writeByte(0x00);
                
                if (chunks.wasNext(0x20))
                {
                    M.writeMultibyte(battlerAnimations.getLength());
                    battlerAnimations.write();
                }
                
                dbWriter.Close();
                M.targetWriter.Close();
                File.Delete(filepath + ".bak");
            }
            catch (Exception e)
            {
                M.debugMessage(e.StackTrace);
                M.debugMessage(e.Message);
                Console.WriteLine("Aborting due to error; keeping original file.");
                
                // Close file and restore backup.
                dbWriter.Close();
                M.targetWriter.Close();
                File.Delete(filepath);
                File.Move(filepath + ".bak", filepath);
                return false;
            }
            
            return true;
        }
    }
}
